//precision highp float;
varying vec2 v_texCoord;
varying vec2 v_viewTexCoord;
uniform float u_lightIntensity;
uniform float u_opacity;

uniform vec2 u_gridCellSize; //background particle uv size
uniform vec2 u_gridSize;//background particle uv size

uniform vec2 u_backPixelSize; //background particle uv size
uniform vec2 u_backCellSize; //background particle uv size

void main()
{
    //cell coord
    vec2 gridCellCoords = (floor(v_texCoord /u_gridCellSize) ); //0-gridwidth
    vec2 backCellCoords = gridCellCoords * u_backCellSize;
    //offset
    vec2 cellUVOffset= mod (v_texCoord, u_gridCellSize) /  u_gridCellSize * u_backCellSize;

    
    vec2 texUVCoord = mod(backCellCoords + cellUVOffset, 1.0);
    vec4 color = texture2D(CC_Texture1, texUVCoord);
    vec4 lights = vec4(0.0);
    
    if(u_lightIntensity> 0.0){
        lights = texture2D(CC_Texture2, texUVCoord) ;
        color = (1.0-lights.a * u_lightIntensity) * color + lights.a *u_lightIntensity * lights;
    }
  
    
    gl_FragColor = color * u_opacity;
}
